/*
 * Decompiled with CFR 0.152.
 */
package skeletonapplet;

import java.io.PrintWriter;
import java.util.Calendar;

public class JreDatum {
    protected String prettyName;
    protected String name;
    protected String staticValue;
    protected Calendar staticDate;
    protected String dynamicValue;
    protected Calendar dynamicDate;
    protected String comment = "";
    protected Object status = STATUS_UNAVAILABLE;
    public static final Object STATUS_ERROR = "Error";
    public static final Object STATUS_INFORMATIONAL = "Informational";
    public static final Object STATUS_OK = "OK";
    public static final Object STATUS_UNAVAILABLE = "N/A";
    public static final Object STATUS_WARNING = "Warning";

    public JreDatum(String string, String string2) {
        this.prettyName = string;
        this.name = string2;
    }

    public void toString(PrintWriter printWriter) {
        if (this.staticValue == null) {
            printWriter.println(this.prettyName + " undetermined");
        } else {
            printWriter.println(this.prettyName + " = [" + this.dynamicValue + "]");
            if (!this.staticValue.equals(this.dynamicValue)) {
                printWriter.println("\t(Initially [" + this.staticValue + "]");
            }
        }
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public String getName() {
        return this.name;
    }

    public void setValue(String string) {
        String string2;
        Calendar calendar = Calendar.getInstance();
        this.dynamicValue = string2 = string == null ? "<blank>" : string;
        this.dynamicDate = calendar;
        if (this.staticValue == null) {
            this.staticValue = string2;
            this.staticDate = calendar;
        }
    }

    public void setValue(String string, Object object, String string2) {
        this.setValue(string);
        this.setStatus(object, string2);
    }

    public void setValueError(String string, String string2) {
        this.setValue(string, STATUS_ERROR, string2);
    }

    public void setValueInformational(String string) {
        this.setValue(string, STATUS_INFORMATIONAL, "");
    }

    public void setValueOkay(String string) {
        this.setValue(string, STATUS_OK, "");
    }

    public void setValueUnavailable() {
        this.setValue("N/A", STATUS_UNAVAILABLE, "");
    }

    public String getStaticValue() {
        return this.staticValue;
    }

    public Calendar getStaticDate() {
        return this.staticDate;
    }

    public String getDynamicValue() {
        return this.dynamicValue;
    }

    public Calendar getDynamicDate() {
        return this.dynamicDate;
    }

    public boolean hasComment() {
        return this.comment != null && this.comment.trim().length() > 0;
    }

    public String getComment() {
        return this.comment;
    }

    public boolean isError() {
        return this.status == STATUS_ERROR;
    }

    public boolean isOkay() {
        return this.status == STATUS_OK;
    }

    public boolean isUnavailable() {
        return this.status == STATUS_UNAVAILABLE;
    }

    public boolean isWarning() {
        return this.status == STATUS_WARNING;
    }

    public void setStatus(Object object) {
        this.setStatus(object, "");
    }

    public void setStatus(Object object, String string) {
        this.status = object;
        this.comment = string;
    }
}

